<?php
include_once __dir__ . "/../vendor/autoload.php";
include_once __dir__ . '/../core/email/SendEmail.php';

use CodeInc\StripAccents\StripAccents;
use GuzzleHttp\Client;

//const EMAIL = 'lukas.freire2011@gmail.com';//ANTIGO
const EMAIL = 'adm@memprega.com.br'; //PRODUÇÃO && SANDBOX
//const TOKEN = '4b6ea431-8013-49d4-b9c2-2077d82c0d80cea031c742c5a97371a75d2b7cb23009d6c1-f764-4dab-b0f5-f944dca8329d'; //ANTIGO
// const TOKEN = 'fcf8ee6c-ce81-4571-ba20-3fb5c31805b428da3abd4d43a59d8fbd99f4418877a27c8a-1bd6-482c-b7e2-7a5645d54c17'; //PRODUÇÃO
const TOKEN = '0A4208041B24408B98F82D52719E85B7'; //SANDBOX

const PLAN_CODES = array(
    // 'D6BF97AC2525309CC4499F898747EC2B' => 35.90,
    // '59B079470B0B8E64447B1F98909DFFA7' => 9.90,
    '0ED70BA25C5C6BA224668FB3DCAE9C81' => 2207.00, //PLANO Anual À VISTA
    '532AD6BA434399C884E71F8AB7238728' => 192.25, //PLANO Anual Parcelado
    '1B340CDC7777CF6AA46BBFB566DF8F0E' => 1492.96, // PLANO Semestral À VISTA
    'AA16FE13ECECC30EE4EECFB1A5CFD544' => 257.16, //PLANO Semestral Parcelado
    '0C41E2966A6ACE86641B2FBA47A8C07E' => 4788.84, //PLANO Mensal À VISTA
    'AFFA47C3EFEFE33224F10FBE2E389692' => 399.07, //PLANO Mensal Parcelado
    
);

const MAPPING = array(
    'YEARLY_BUSINESS' => '532AD6BA434399C884E71F8AB7238728',
    'YEARLY_BUSINESS2' => '0ED70BA25C5C6BA224668FB3DCAE9C81',
    'SIXMONTHLY_BUSINESS' => 'AA16FE13ECECC30EE4EECFB1A5CFD544',
    'SIXMONTHLY_BUSINESS2' => '1B340CDC7777CF6AA46BBFB566DF8F0E',
    'MONTHLY_BUSINESS' => 'AFFA47C3EFEFE33224F10FBE2E389692',
    'MONTHLY_BUSINESS2' => '0C41E2966A6ACE86641B2FBA47A8C07E',
);

const STATES = array(
	'AC' => 'Acre',
	'AL' => 'Alagoas',
	'AP' => 'Amapá',
	'AM' => 'Amazonas',
	'BA' => 'Bahia',
	'CE' => 'Ceará',
	'DF' => 'Distrito Federal',
	'ES' => 'Espirito Santo',
	'GO' => 'Goiás',
	'MA' => 'Maranhão',
	'MS' => 'Mato Grosso do Sul',
	'MT' => 'Mato Grosso',
	'MG' => 'Minas Gerais',
	'PA' => 'Pará',
	'PB' => 'Paraíba',
	'PR' => 'Paraná',
	'PE' => 'Pernambuco',
	'PI' => 'Piauí',
	'RJ' => 'Rio de Janeiro',
	'RN' => 'Rio Grande do Norte',
	'RS' => 'Rio Grande do Sul',
	'RO' => 'Rondônia',
	'RR' => 'Roraima',
	'SC' => 'Santa Catarina',
	'SP' => 'São Paulo',
	'SE' => 'Sergipe',
	'TO' => 'Tocantins',
);
const STATUS_TEXT = array(
    'INITIATED' => 'Iniciou o processo de pagamento, mas abandonou o checkout e não concluiu a compra',
    'PENDING' => 'O processo de pagamento foi concluído e a transação está em análise ou aguardando a confirmação da operadora',
    'ACTIVE' => 'A criação da assinatura, transação validadora ou transação recorrente foi aprovada',
    'PAYMENT_METHOD_CHANGE' => 'A transação retornou como "Cartão Expirado, Cancelado ou Bloqueado" e o cartão da assinatura precisa ser substituído',
    'SUSPENDED' => 'A assinatura foi suspensa pela empresa',
    'CANCELLED' => 'A adesão da assinatura não foi aprovada e o pedido foi cancelado',
    'CANCELLED_BY_RECEIVER' => 'A assinatura foi cancelada a pedido do vendedor',
    'CANCELLED_BY_SENDER' => 'A assinatura foi cancelada a pedido do comprador',
    'EXPIRED' => 'A assinatura expirou por atingir a data limite da vigência ou por ter atingido o valor máximo de cobrança definido na cobrança do plano'
);

class Pagseguro extends Core {

    function __construct($conn) {

        parent::__construct($conn);
        \PagSeguro\Library::initialize();
        \PagSeguro\Library::cmsVersion()->setName("Memprega")->setRelease("1.0.0");
        \PagSeguro\Library::moduleVersion()->setName("Memprega")->setRelease("1.0.0");
        \PagSeguro\Configuration\Configure::setEnvironment('sandbox');//production or sandbox
        \PagSeguro\Configuration\Configure::setAccountCredentials(
            EMAIL,
            TOKEN
        );
        \PagSeguro\Configuration\Configure::setCharset('UTF-8');// UTF-8 or ISO-8859-1
        \PagSeguro\Configuration\Configure::setLog(true, __dir__ . '/../pagseguro.txt');

    }

    function getSession() {

        $sessionCode = \PagSeguro\Services\Session::create(
            \PagSeguro\Configuration\Configure::getAccountCredentials()
        );
        return [ 'type' => 'OK', 'data' => $sessionCode->getResult() ];    

    }

    function payment() {

        ini_set('display_errors', 1);
        ini_set('display_startup_errors', 1);
        error_reporting(E_ALL);

        $user_id = $_POST['userId'];
        $card_token = $_POST['cardToken'];
        $card_holder_name = $_POST['holderName'];
        $plan_select = $_POST['planSelect'];
        $plan_code = MAPPING[$plan_select];
        
        file_put_contents('Cartão_PAGSEG.TXT', print_r($_POST, true), FILE_APPEND);
        //exit;
        
        $sql = "SELECT * FROM leads WHERE id = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $user_id ]);
        $user = $stmt->fetch(PDO::FETCH_ASSOC);
        //$plan_code = $user['signature_plan_id'];
        
        //BEGIN
        $plan_price = PLAN_CODES[$plan_code];
         $sql = "UPDATE leads SET signature_plan_id = ?, plan_signature = ? WHERE id = ?";
         $stmt = parent::$conn->prepare($sql);
         $stmt->execute([ $plan_select, $plan_price, $user_id ]);
        
        // $state_uf = null;
        $state_uf = $_POST['state'];
        
        // if($user['state'] !== null && !empty($user['state'])) {
            
        //     foreach(STATES as $key=>$state) {
        //         $user_state = strtolower(StripAccents::strip($user['state']));
        //         $state_name = strtolower(StripAccents::strip($state));
                
        //         if($user_state === $state_name) {
        //             $state_uf = $key;
        //             break;
        //         }
        //     }

        // } else {

        //     $uf = explode(',',$user['city'])[1];
            
        //     $state_uf = strtoupper(trim($uf));

        // }
        
        //$user_phone = preg_replace('/\D/gmi', '', $user['phone']);
        $user_phone = $_POST['phone'];
        
        $user_phone_ddd = substr($user_phone, 0, 2);
        $user_phone_number = substr($user_phone, 2);
        
        //dados do assinante pessoa fisica
        // $preApproval = new \PagSeguro\Domains\Requests\DirectPreApproval\Accession();
        // $preApproval->setPlan($plan_code);
        // $preApproval->setReference(uniqid('sign_'));
        // $preApproval->setSender()->setName($_POST['fullname']);//assinante
        // $preApproval->setSender()->setEmail($user['email']);//assinante
        // $preApproval->setSender()->setIp($_SERVER['REMOTE_ADDR']);//assinante
        // $preApproval->setSender()->setAddress()
        //     ->withParameters($_POST['street'], $_POST['number'], $_POST['district'], $_POST['zipCode'], $_POST['city'], $state_uf, 'BRA');//assinante
        // $document = new \PagSeguro\Domains\DirectPreApproval\Document();
        // $document->withParameters('CPF', $_POST['cpf']); //assinante
        // $preApproval->setSender()->setDocuments($document);
        // $preApproval->setSender()->setPhone()->withParameters($user_phone_ddd, $user_phone_number); //assinante
        
        file_put_contents('PAGSEG.TXT', 'PLANO ESCOLHIDO - ID:'.$plan_code, FILE_APPEND);
        
        //dados do assinante empresa
        $preApproval = new \PagSeguro\Domains\Requests\DirectPreApproval\Accession();
        $preApproval->setPlan($plan_code);
        $preApproval->setReference(uniqid('sign_'));
        $preApproval->setSender()->setName($_POST['companyName']);//assinante
        $preApproval->setSender()->setEmail($user['email']);//assinante
        $preApproval->setSender()->setIp($_SERVER['REMOTE_ADDR']);//assinante
        
        if(empty($user['signature_date'])){
            $periodo_teste_dias = 15; // Período de teste padrão
            $preApproval->setTrial()->setDuration($periodo_teste_dias)->setUnit('days')->setCharge('AUTO')->setPeriod('MONTHLY')->setTrialPeriodDuration($periodo_teste_dias); // Define o período de teste na assinatura
        }    
        
        
        if(!empty($user["cupom"]) && empty($user['cupom_check'])){
            
            $sql = "UPDATE leads SET cupom_check = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user['cupom'], $user_id ]);
        
            $cnpj_base64 = base64_encode($cnpj);
            $sql2 = "SELECT validade FROM cupons WHERE cupom = ?";
            $stmt2 = parent::$conn->prepare($sql2);
            $stmt2->execute([$cnpj_base64]);
            $cupom = $stmt2->fetch(PDO::FETCH_ASSOC);
        
            $cupom_validade = $cupom['validade'];
        
            // Lógica para obter a data de validade do cupom (exemplo: $cupom_validade)
            $data_validade = new DateTime($cupom_validade);
            $data_atual = new DateTime();
            $diferenca_dias = $data_atual->diff($data_validade)->days;
            $periodo_teste_dias = $diferenca_dias;
            $preApproval->setTrial()->setDuration($periodo_teste_dias)->setUnit('days')->setCharge('AUTO')->setPeriod('MONTHLY')->setTrialPeriodDuration($periodo_teste_dias); // Define o período de teste na assinatura
            
        }
        
        $preApproval->setSender()->setAddress()
            ->withParameters($_POST['street'], $_POST['number'], $_POST['district'], $_POST['zipCode'], $_POST['city'], $state_uf, 'BRA');//assinante
        $document = new \PagSeguro\Domains\DirectPreApproval\Document();
        $document->withParameters('CNPJ', $_POST['cnpj']); //empresa
        $preApproval->setSender()->setDocuments($document);
        $preApproval->setSender()->setPhone()->withParameters($user_phone_ddd, $user_phone_number); //assinante
        
        //dados do titular do cartão
        $user_birthdate = DateTime::createFromFormat('d/m/Y', $_POST['birthdate']);
        $user_birthdate = $user_birthdate->format('d/m/Y');
        $holder_birthdate_fdate = $user_birthdate;
        $tax_document_number = $_POST['cpf'];
        $holder_phone_ddd = substr($_POST['phone'], 0, 2);
        $holder_phone_number = substr($_POST['phone'], 2);
        $street = $_POST['street'];
        $streetNumber = $_POST['number'];
        $district = $_POST['district'];
        $zip_code = $_POST['zipCode'];
        $city = $_POST['city'];
        $state_uf = $_POST['state'];        

        $preApproval->setPaymentMethod()->setCreditCard()->setToken($card_token); //token do cartão de crédito gerado via javascript
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setName($card_holder_name); //nome do titular do cartão de crédito
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setBirthDate($holder_birthdate_fdate); //data de nascimento do titular do cartão de crédito
        $document = new \PagSeguro\Domains\DirectPreApproval\Document();
        $document->withParameters('CPF', $tax_document_number); //cpf do titular do cartão de crédito
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setDocuments($document);
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setPhone()
            ->withParameters($holder_phone_ddd, $holder_phone_number); //telefone do titular do cartão de crédito
        $preApproval->setPaymentMethod()->setCreditCard()->setHolder()->setBillingAddress()
            ->withParameters($street, $streetNumber, $district, $zip_code, $city, $state_uf, 'BRA'); //endereço do titular do cartão de crédito
        
        try {
            
            $response = $preApproval->register(
                new \PagSeguro\Domains\AccountCredentials(EMAIL, TOKEN) // credencias do vendedor no pagseguro
            );
            
            $signature_id = $response->code;
            $signature_date = date('Y-m-d');
            $signature_status_text = 'Liberado momentaneamente, esperando autorização da operadora do cartão';
            $sql = "UPDATE leads SET signature_id = ?, voucher = NULL, signature_status = 'ACTIVE', signature_status_text = ?, signature_date = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $signature_id, $signature_status_text, $signature_date, $user_id ]);
            //adiciona no segmento de assinatura pendente = ID 42
            
            $sql = "INSERT IGNORE INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                VALUES(42, ?,NOW(), 0, 0)";        
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user_id ]);
            
            return [ 
                'type' => 'OK', 
                'data' => [
                    'id' => $signature_id
                ]
            ];

        } catch(\Exception $err) {

            file_put_contents('error.txt', print_r($err->getMessage(), true));

        }

    }

    function notification() {

        file_put_contents('PAGSEG.TXT', 'CHEGOU AQUI - '.print_r($_POST,true), FILE_APPEND);

        try {

            $response = \PagSeguro\Services\PreApproval\Notification::check(
                \PagSeguro\Configuration\Configure::getAccountCredentials()
            );
            $code = $response->getCode();
            $status = $response->getStatus();
            $last_date = $response->getLastEventDate();
            $tracker = $response->getTracker();            

            $sql = "UPDATE leads SET signature_status = :status, 
                signature_last_event_date = :last_date,
                signature_status_text = :status_text,
                signature_reference = :tracker
                WHERE signature_id = :code";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                ':status' => $status,
                ':status_text' => STATUS_TEXT[$status] ?? NULL,
                ':last_date' => $last_date,
                ':code' => $code,
                ':tracker' => $tracker
            ]); 
            
            $sql = "SELECT id FROM leads WHERE signature_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $code ]);
            $user = $stmt->fetch(PDO::FETCH_ASSOC);
            
            //deleta se estiver nos segmentos de pendentes ou cancelados
            $sql = "DELETE FROM lead_lists_leads WHERE leadlist_id IN(42, 41, 39) AND lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $user['id'] ]);

            if($status === 'ACTIVE') {

                $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(39, ?,NOW(), 0, 0)";   
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([ $user['id'] ]);

            } else if($status !== 'PENDING') {

                //Segmentos dos cancelados, ID  41
                $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
                    VALUES(41, ?,NOW(), 0, 0)";        
                $stmt = parent::$conn->prepare($sql);
                $stmt->execute([ $user['id'] ]);
                
            }
            
            //se cartão for aprovado então adiciona usuário no segmento "Assinantes" = ID 39            
            

        } catch (Exception $e) {            
            http_response_code(500);
        }
        
        http_response_code(200);

    }

    function cancelSignature() {

        $email = $_POST['email'];
        $phone = $_POST['phone'];
        $reason = $_POST['reason'];

        $content = <<<EOF
<!DOCTYPE html>
<html lang="pt_br">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Memprega</title>
</head>
<body>
    <h3>Novo pedido de cancelamanto de plano</h3>
    <h3>Informações para contato</h3>
    <p>Email: $email</p>
    <p>Telefone: $phone</p>
    <hr/>
    <p>Motivo: $reason</p>
</body>
EOF;

        $sender = new SendEmail(parent::$conn);
        $sender->send('contato@memprega.com.br', 'Memprega', $content, 'Novo pedido de cancelamanto de plano');

        return ['type' => 'OK'];

    }

    /*function cancelSignature() {

        $id = $_GET['id'];

        $sql = "SELECT signature_id FROM leads WHERE id = ?";
        $stmt = parent::$conn->prepare($sql);
        $stmt->execute([ $id ]);
        $signature = $stmt->fetch(PDO::FETCH_ASSOC);
        $code = $signature['signature_id'];

        try {

            \PagSeguro\Services\PreApproval\Cancel::create(
                \PagSeguro\Configuration\Configure::getAccountCredentials(),
                $code
            );

            $sql = "UPDATE lead SET signature_id = NULL, signature_status = 'CANCELLED', 
                signature_status_text = :signature_status_text 
                WHERE id = :id ";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                ':signature_status_text' => STATUS_TEXT['CANCELLED'],
                ':id' => $id
            ]);

            $sql = "DELETE FROM lead_lists_leads WHERE leadlist_id = 42 AND lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            //Segmentos dos cancelados, ID  41
            $sql = "INSERT INTO lead_lists_leads(leadlist_id, lead_id, date_added, manually_removed, manually_added)
            VALUES(41, ?,NOW(), 0, 0)";        
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

        } catch (Exception $e) {
            return [ 'type' => 'FAIL' ];
        }

        return ['type' => 'OK'];

    }*/
    
    function createPlansInSandbox() {
        
        file_put_contents('PAGSEG.TXT', 'CRIAR PLANO SANDBOX - '.print_r($_POST,true), FILE_APPEND);
    
        new \PagSeguro\Domains\Requests\DirectPreApproval\Plan;
        
        // Configuração do PagSeguro (substitua com suas credenciais e ambiente de sandbox)
        PagSeguro::setEmail(EMAIL);
        PagSeguro::setToken(TOKEN);
        PagSeguro::setEnvironment('sandbox');
    
        $plans = array(
            array(
                'name' => 'Plano Anual Parcelado SANDBOX',
                'amount' => '192.25',
                'currency' => 'BRL',
                'interval' => array(
                    'unit' => 'MONTH',
                    'length' => 1
                ),
                'trial' => array(
                    'enabled' => false,
                    'hold_setup_fee' => false
                ),
                'payment_method' => array('CREDIT_CARD')
            ),
            // Adicione aqui os outros planos que deseja criar
        );
    
        foreach ($plans as $planData) {
            $plan = new Plan();
            $plan->setName($planData['name']);
            $plan->setAmount($planData['amount']);
            $plan->setPeriod($planData['interval']['unit']);
            $plan->setInterval($planData['interval']['length']);
            $plan->setTrial($planData['trial']['enabled'], $planData['trial']['hold_setup_fee']);
            $plan->setPaymentMethod($planData['payment_method']);
    
            try {
                $response = $plan->create();
                echo "Plano criado com sucesso: " . $response->getCode() . "\n";
                file_put_contents('PLANS.TXT', 'Plano criado com sucesso - REF: '.$response->getCode().PHP_EOL, FILE_APPEND);
            } catch (\Exception $e) {
                file_put_contents('PLANS.TXT', 'Plano erro - ERROR: '.$e->getMessage().PHP_EOL, FILE_APPEND);
                echo "Erro ao criar o plano: " . $e->getMessage() . "\n";
            }
        }
    
    }


}