<?php

    class ProfessionalExperiences extends Core {

        function list() {

            $id = $_GET['id'];

            $sql = "SELECT * FROM professional_experiences WHERE lead_id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([$id]);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            return [ 'type' => 'OK', 'data' => $result ];

        }

        function update() {
            
            $id = $_POST['id'];
            $company = $_POST['company'];
            $vacancy = $_POST['vacancy'];
            $branch = $_POST['branch'];
            $roleLevel = $_POST['roleLevel'];
            $specializationName = $_POST['specializationName'];
            $admission_date = $_POST['admissionDate'];
            $departure_date = $_POST['currentJob'] == 'true' ? null : $_POST['departureDate'];
            $salary = $_POST['salary'];
            $description = $_POST['description'];
            $office = $_POST['office'];
            $ocupacao = $_POST['ocupacao'];
            $sinonimo = $_POST['sinonimo'];

            $sql = "UPDATE professional_experiences SET organization = ?, office = ?, professional_name = ?, 
                branch = ?, role_level = ?, specialization_name = ?, init_date = ?, final_date = ?, salary = ?, description = ?, ocupacao = ?, sinonimo = ?
                WHERE id = ?";
            
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                $company,
                $office,
                $vacancy,
                $branch,
                $roleLevel,
                $specializationName,
                $admission_date,
                $departure_date,
                $salary,
                $description,
                $ocupacao,
                $sinonimo,
                $id
            ]);

            return [ 'type' => 'OK' ];

        }

        function store() {

            $lead_id = $_POST['lead_id'];
            $company = $_POST['company'];
            $vacancy = $_POST['vacancy'];
            $branch = $_POST['branch'];
            $roleLevel = $_POST['roleLevel'];
            $specializationName = $_POST['specializationName'];
            $admission_date = $_POST['admissionDate'];
            $departure_date = $_POST['currentJob'] == 'true' ? null : $_POST['departureDate'];
            $salary = $_POST['salary'];
            $description = $_POST['description'];
            $office = $_POST['office'];
            $ocupacao = $_POST['ocupacao'];
            $sinonimo = $_POST['sinonimo'];
            
            $sql = "INSERT INTO professional_experiences(lead_id, organization, office, professional_name, branch, role_level, 
                specialization_name, init_date, final_date, salary, description, ocupacao, sinonimo) 
                VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([
                $lead_id,
                $company,
                $office,
                $vacancy,
                $branch,
                $roleLevel,
                $specializationName,                
                $admission_date,
                $departure_date,
                $salary,
                $description,
                $ocupacao,
                $sinonimo
            ]);

            return ['type' => 'OK'];

        }

        function delete() {

            $id = $_GET['id'];

            $sql = "DELETE FROM professional_experiences WHERE id = ? ORDER BY id DESC";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);

            return [ 'type' => 'OK', 'data' => $stmt->rowCount() ];

        }

        function getDesiredJobTitle() {

            $id = $_GET['id'];
            $sql = "SELECT desired_job_title, is_pcd, pcd_description FROM leads WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $id ]);
            $result = $stmt->fetch(PDO::FETCH_ASSOC);
            return [ 'type' => 'OK', 'data' => $result ];

        }

        function setDesiredJobTitle() {

            $id = $_POST['lead_id'];
            $desired_job_title = $_POST['desiredJobTitle'];
            $is_pcd = $_POST['isPcd'];
            $pcd_description = $_POST['pcdDescription'];

            $sql = "UPDATE leads SET desired_job_title = ?, is_pcd = ?, pcd_description = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $desired_job_title, $is_pcd, $pcd_description, $id ]);

            return [ 'type' => 'OK', 'data' => $stmt->rowCount() ];

        }

        function setPcdDescription() {

            $id = $_POST['lead_id'];
            $pcd_description = $_POST['pcdDescription'];
            $sql = "UPDATE leads SET pcd_description = ? WHERE id = ?";
            $stmt = parent::$conn->prepare($sql);
            $stmt->execute([ $pcd_description, $id ]);

            return [ 'type' => 'OK', 'data' => $stmt->rowCount() ];

        }

        function listVancancies() {

            $sql = "SELECT * FROM vacancies ORDER BY term";
            $stmt = parent::$conn->query($sql);
            $result = $stmt->fetchAll(PDO::FETCH_ASSOC);
            
            return [ 'type' => 'OK', 'data' => $result ];
            
        }

    }